#!/bin/bash
#
# BSP-3243 Only for Safety Wifi APs: migrate to min 12Mbit rate

PRESERVEDPATH=$1
[ -z $PRESERVEDPATH ] && exit 1

AP_CONF=$(ls $PRESERVEDPATH/etc/hostapd/*.conf)
[ -e "$AP_CONF" ] || exit 0
[ $(echo "$AP_CONF" | wc -w) = 1 ] || exit 0

IFACE="$(basename $AP_CONF .conf)"
grep -q "interfaces\\\\$IFACE\\\\config=safety" $PRESERVEDPATH/etc/EPAD/system.ini || exit 0

cat << EOF >> $AP_CONF
supported_rates=120 180 240 360 480 540
basic_rates=120 180 240 360 480 540
EOF
